package fr.asip.cps3.exemple.vues.ecrans.saisie;

import java.awt.GridBagLayout;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

import fr.asip.cps3.exemple.vues.FenetrePrincipale;
import fr.asip.cps3.exemple.vues.composants.GridBagHelper;
import fr.asip.cps3.exemple.vues.ecrans.EcranUtil;

/**
 * Classe permettant de modliser l'cran de saisie d'un Seed
 */
public class SaisieSeed extends Saisie {

	/**
	 * Libell Seed 
	 */
	protected JLabel libelleSeed;
	
	/**
	 * Texte Seed
	 */
	protected JTextField texteSeed;
	
	/**
	 * Constructeur
	 * @param fenetre La fentre qui doit contenir l'cran de saisie
	 */
	public SaisieSeed(FenetrePrincipale fenetre, int typeEcran) {

		super(fenetre,typeEcran);
		libelleSeed = new JLabel("Saisir la graine (seed) :");
		texteSeed = new JTextField(32);
    	
	}

	/**
     * Renvoie le Seed
     * @return Seed
     */
	public char[] getSeed() {
		if(texteSeed.getText() != null)
			return texteSeed.getText().toCharArray();
		return null;
	}

	/**
	 * Affiche les champs d'entre
	 * @param fenetre La fentre qui doit contenir l'cran d'entre
	 */
    public void affiche() {

    	JFrame fenetre = this.fenetre.getFenetre();
    	
    	if(fenetre != null && fenetre.getContentPane() != null) {
    	
	    	EcranUtil.supprimeTousLesComposants(((JPanel)fenetre.getContentPane()));
	    	
	        // Cration du layout
	    	((JPanel)fenetre.getContentPane()).setBorder(new EmptyBorder(0, 0, 0, 0));
	        GridBagLayout layout = new GridBagLayout();
	        ((JPanel)fenetre.getContentPane()).setLayout(layout);
	        
	        // Ajout des composants
	        GridBagHelper g = new GridBagHelper(fenetre.getContentPane());
	        // Ligne 0
	        g.ajoute(libelleSeed, EcranUtil.styleLibelleSaisie, 0, 0, 1, 1);
	        g.ajoute(texteSeed, EcranUtil.styleChampTexteSaisie, 0, 1, 1, 1);
	        // Ligne 1
	        g.ajoute(soumettre, EcranUtil.styleBoutonSoumettre, 1, 0, 1, 2);
	        // Ligne 2
	        g.ajoute(barreStatut, EcranUtil.styleBarreStatut, 2, 0, 1, 2);
	        
    	}
    }
}
